unit Polymorph;

interface
uses SysUtils;

//   
//  
type TT1 = class (TObject)
   function ConvertToStr (RqVar : string)  : string; overload;
end;
//  2
type TT2 = class (TT1)
   function ConvertToStr (RqVar : boolean) : string; overload;
end;
//  3
type TT3 = class (TT2)
   function ConvertToStr (RqVar : real)    : string; overload;
end;

implementation

//  
function TT1.ConvertToStr  (RqVar : string) : string;
begin
   Result := RqVar;
end;
//  a 2
function TT2.ConvertToStr  (RqVar : boolean) : string;
begin
   Result := BoolToStr(RqVar, True);
end;
//  a 3
function TT3.ConvertToStr  (RqVar : real) : string;
begin
   Result := FloatToStr(RqVar);
end;

end.
